/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.IVWLinkerTable;
import filenet.vw.apps.linker.VWLinkerDocTableModel;
import filenet.vw.apps.linker.VWLinkerTablePanel;
import filenet.vw.apps.linker.VWLinkerWFTableModel;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.IVWIDMLink;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

class VWDocumentLinkPanel
extends JPanel {
    private VWLinkerTablePanel m_linkTablePanel = null;
    private Frame m_parentFrame = null;
    private IVWIDMLibrary m_library = null;
    private int m_nLinkType = -1;
    private IVWIDMDocument m_document = null;
    private IVWIDMLink[] m_workflowLinks = null;
    private IVWLinkerTable m_linkTableModel = null;

    public VWDocumentLinkPanel(Frame parentFrame, IVWIDMLibrary library, int nLinkType, IVWIDMDocument document) {
        this.m_parentFrame = parentFrame;
        this.m_library = library;
        this.m_nLinkType = nLinkType;
        this.m_document = document;
        this.layoutControls();
    }

    private void layoutControls() {
        try {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createTopPanel(), "First");
            this.add((Component)this.createMiddlePanel(), "Center");
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
    }

    private JPanel createTopPanel() {
        JPanel subPanel = null;
        GridBagConstraints gbConst = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new GridBagLayout());
            gbConst = new GridBagConstraints();
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(0, 10, 0, 0);
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.gridwidth = 0;
            subPanel.add((Component)this.createTitlePanel(), gbConst);
            ++gbConst.gridy;
            gbConst.insets = new Insets(10, 10, 10, 0);
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            if (this.m_nLinkType == 2) {
                subPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.DocumentNameLabel)), gbConst);
            } else {
                subPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.WorkflowTitleLabel)), gbConst);
            }
            ++gbConst.gridx;
            gbConst.gridwidth = -1;
            subPanel.add((Component)new JLabel(this.m_document.getLabel()), gbConst);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            subPanel.add(Box.createVerticalStrut(10), gbConst);
            if (this.m_nLinkType == 3) {
                gbConst.gridx = 0;
                ++gbConst.gridy;
                gbConst.fill = 0;
                gbConst.weightx = 0.0;
                gbConst.gridwidth = 1;
                subPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.LatestVersionLabel)), gbConst);
                ++gbConst.gridx;
                gbConst.gridwidth = -1;
                subPanel.add((Component)new JLabel(this.m_document.getVersionNumber()), gbConst);
                ++gbConst.gridx;
                gbConst.fill = 2;
                gbConst.weightx = 1.0;
                gbConst.gridwidth = 0;
                subPanel.add(Box.createVerticalStrut(10), gbConst);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }

    private JPanel createTitlePanel() {
        JPanel subPanel = null;
        String title = null;
        Font aFont = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new BorderLayout(0, 0));
            switch (this.m_nLinkType) {
                case 2: {
                    title = VWResource.DocumentWorkflowLinks;
                    break;
                }
                case 3: {
                    title = VWResource.WorkflowDocumentLinks;
                }
            }
            JLabel titleLabel = new JLabel(title, 0);
            aFont = this.getFont();
            if (aFont != null) {
                titleLabel.setFont(new Font(aFont.getName(), 1, aFont.getSize() + 2));
            }
            subPanel.add((Component)titleLabel, "Center");
            subPanel.add(Box.createVerticalStrut(50), "After");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }

    private JPanel createMiddlePanel() {
        JPanel subPanel = null;
        try {
            subPanel = new JPanel();
            Dimension dim = VWStringUtils.stringToDimension(VWResource.LinkerPanelPrefDim);
            if (dim == null) {
                dim = new Dimension(400, 400);
            }
            subPanel.setPreferredSize(dim);
            subPanel.setLayout(new BorderLayout());
            this.m_linkTableModel = this.m_document.isWorkflowDefinition() ? new VWLinkerWFTableModel() : new VWLinkerDocTableModel();
            if (this.m_linkTableModel != null) {
                this.m_linkTableModel.setLibrary(this.m_library);
            }
            if (this.m_nLinkType == 2) {
                subPanel.setBorder(new VWTitledBorder(VWResource.WorkflowLinkedToDocument));
                this.m_workflowLinks = this.m_document.getWorkflowLinks(-1, -1);
            } else if (this.m_nLinkType == 3) {
                subPanel.setBorder(new VWTitledBorder(VWResource.DocClassLinkedToWorkflow));
                this.m_workflowLinks = this.m_library.getWorkflowLinks(null, null, this.m_document.getId(), -1, -1);
            }
            if (this.m_workflowLinks != null) {
                for (int i = 0; i < this.m_workflowLinks.length; ++i) {
                    this.m_linkTableModel.addLink(this.m_workflowLinks[i]);
                }
            }
            this.m_linkTablePanel = new VWLinkerTablePanel();
            if (this.m_nLinkType == 2) {
                this.m_linkTablePanel.init(this.m_parentFrame, this.m_document, this.m_linkTableModel, 2);
            } else {
                this.m_linkTablePanel.init(this.m_parentFrame, this.m_document, this.m_linkTableModel, 3);
            }
            subPanel.add((Component)this.m_linkTablePanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }
}

